% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-shared.R
\name{build_token}
\alias{build_token}
\title{Builds hash for a call}
\usage{
build_token(values, secret = NULL)
}
\arguments{
\item{values}{R object that is going to be signed}

\item{secret}{string that contains the shared secret to sign the
communication. It can be NULL on both telemetry and in plumber API to
disable this communication feature}
}
\value{
A string that contains an hash to uniquely identify the parameters.
}
\description{
Function that takes creates a signature for the \code{values} using a secret.
}
\details{
This is used in shiny.telemetry, but also externally with the Plumber
endpoint.
}
\examples{
build_token(values = list(list(1, 2, 3), 2, 2, 3, "bb"))
build_token(values = list(list(1, 2, 3), 1, 2, 3, "bb"))
build_token(values = list(list(1, 2, 3), 1, 2, 3, "bb"), secret = "abc")
build_token(values = list(list(1, 2, 3), 1, 2, 3, "bb"), secret = "abd")
}
