% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nth_pnt_aggregator.R
\docType{class}
\name{nth_pnt_aggregator}
\alias{nth_pnt_aggregator}
\title{Aggregation which returns every Nth point.}
\format{
An \code{R6::R6Class} object
}
\description{
Aggregation by extracting every Nth data.
}
\examples{
data(noise_fluct)
agg <- nth_pnt_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500, 1000)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")
}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{nth_pnt_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-nth_pnt_aggregator-new}{\code{nth_pnt_aggregator$new()}}
\item \href{#method-nth_pnt_aggregator-clone}{\code{nth_pnt_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nth_pnt_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-nth_pnt_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nth_pnt_aggregator$new(..., interleave_gaps, coef_gap, NA_position)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, coef_gap, NA_position, ...}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nth_pnt_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-nth_pnt_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{nth_pnt_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
