% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-download.R
\name{f7DownloadButton}
\alias{f7DownloadButton}
\title{Create a download button}
\usage{
f7DownloadButton(outputId, label = "Download", class = NULL, ...)
}
\arguments{
\item{outputId}{The name of the output slot that the downloadHandler is assigned to.}

\item{label}{The label that should appear on the button.}

\item{class}{Additional CSS classes to apply to the tag, if any.}

\item{...}{Other arguments to pass to the container tag function.}
}
\description{
Use these functions to create a download button;
when clicked, it will initiate a browser download. The
filename and contents are specified by the corresponding
shiny downloadHandler() defined in the server function.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 ui = f7Page(
  f7SingleLayout(
    navbar = f7Navbar(title = "File handling"),
    f7Block(f7DownloadButton("download","Download!"))
  )
 )

 server = function(input, output, session) {
   # Our dataset
   data <- mtcars

   output$download = downloadHandler(
     filename = function() {
       paste("data-", Sys.Date(), ".csv", sep="")
     },
     content = function(file) {
       write.csv(data, file)
     }
   )
 }

 shinyApp(ui, server)
}
}
