% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Picker}
\alias{f7Picker}
\alias{updateF7Picker}
\title{Framework7 picker input}
\usage{
f7Picker(
  inputId,
  label,
  placeholder = NULL,
  value = choices[1],
  choices,
  rotateEffect = TRUE,
  openIn = "auto",
  scrollToInput = FALSE,
  closeByOutsideClick = TRUE,
  toolbar = TRUE,
  toolbarCloseText = "Done",
  sheetSwipeToClose = FALSE,
  style = list(inset = FALSE, outline = FALSE, strong = FALSE, dividers = FALSE),
  ...
)

updateF7Picker(
  inputId,
  value = NULL,
  choices = NULL,
  rotateEffect = NULL,
  openIn = NULL,
  scrollToInput = NULL,
  closeByOutsideClick = NULL,
  toolbar = NULL,
  toolbarCloseText = NULL,
  sheetSwipeToClose = NULL,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Picker input id.}

\item{label}{Picker label.}

\item{placeholder}{Text to write in the container.}

\item{value}{Picker initial value, if any.}

\item{choices}{Picker choices.}

\item{rotateEffect}{Enables 3D rotate effect. Default to TRUE.}

\item{openIn}{Can be auto, popover (to open picker in popover), sheet (to open in sheet modal).
In case of auto will open in sheet modal on small screens and in popover on large screens. Default
to auto.}

\item{scrollToInput}{Scroll viewport (page-content) to input when picker opened. Default
to FALSE.}

\item{closeByOutsideClick}{If enabled, picker will be closed by clicking outside of picker or related input element.
Default to TRUE.}

\item{toolbar}{Enables picker toolbar. Default to TRUE.}

\item{toolbarCloseText}{Text for Done/Close toolbar button.}

\item{sheetSwipeToClose}{Enables ability to close Picker sheet with swipe. Default to FALSE.}

\item{style}{Input style. Inherit from \link{f7List} options
such as outline, inset, strong and dividers.}

\item{...}{Other options to pass to the picker. See
\url{https://framework7.io/docs/picker#picker-parameters}.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\code{f7Picker} generates a picker input.

\code{updateF7Picker} changes the value of a picker input on the client.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "My app",
    f7TabLayout(
      navbar = f7Navbar(title = "Update pickers"),
      f7Tabs(
        f7Tab(
          title = "Standalone",
          tabName = "standalone",
          f7Segment(
            f7Button(inputId = "update", label = "Update picker"),
            f7Button(
              inputId = "removeToolbar",
              label = "Remove picker toolbars",
              color = "red"
            )
          ),
          f7Picker(
            inputId = "picker",
            placeholder = "Some text here!",
            label = "Picker Input",
            choices = c("a", "b", "c"),
            options = list(sheetPush = TRUE),
            style = list(strong = TRUE)
          ),
          f7Block(verbatimTextOutput("pickerval"))
        ),
        f7Tab(
          title = "List",
          tabName = "list",
          f7List(
            strong = TRUE,
            f7Picker(
              inputId = "picker2",
              placeholder = "Some text here!",
              label = "Picker Input",
              choices = c("a", "b", "c"),
              options = list(sheetPush = TRUE)
            )
          ),
          f7Block(verbatimTextOutput("pickerval2"))
        )
      )
    )
  ),
  server = function(input, output, session) {
    output$pickerval <- renderText(input$picker)
    output$pickerval2 <- renderText(input$picker2)

    observeEvent(input$update, {
      updateF7Picker(
        inputId = "picker",
        value = "b",
        choices = letters,
        openIn = "sheet",
        toolbarCloseText = "Close me",
        sheetSwipeToClose = TRUE
      )
    })

    observeEvent(input$removeToolbar, {
      updateF7Picker(
        inputId = "picker",
        value = "b",
        choices = letters,
        openIn = "sheet",
        toolbar = FALSE
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
