% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/from_features.R
\name{SignifFeatureRegion}
\alias{SignifFeatureRegion}
\title{SignifFeatureRegion}
\usage{
SignifFeatureRegion(
  n,
  d,
  gcounts,
  gridsize,
  dest,
  bandwidth,
  signifLevel,
  range.x,
  grad = TRUE,
  curv = TRUE,
  neg.curv.only = TRUE
)
}
\arguments{
\item{n}{The sample size.}

\item{d}{The dimensionality of the data.}

\item{gcounts}{A numeric vector representing data counts.}

\item{gridsize}{A numeric vector specifying the grid size.}

\item{dest}{A kernel density estimate.}

\item{bandwidth}{The bandwidth parameter.}

\item{signifLevel}{The significance level.}

\item{range.x}{The range of x values.}

\item{grad}{A logical value indicating whether to compute the gradient significance.}

\item{curv}{A logical value indicating whether to compute the curvature significance.}

\item{neg.curv.only}{A logical value indicating whether to consider negative curvature only.}
}
\value{
A list containing the significance results for gradient and curvature.
}
\description{
This function computes the significance of features based on gradient and curvature analysis.
}
