% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runapp.R
\name{runExample}
\alias{runExample}
\title{Run Shiny Example Applications}
\usage{
runExample(
  example = NA,
  port = getOption("shiny.port"),
  launch.browser = getOption("shiny.launch.browser", interactive()),
  host = getOption("shiny.host", "127.0.0.1"),
  display.mode = c("auto", "normal", "showcase"),
  package = "shiny"
)
}
\arguments{
\item{example}{The name of the example to run, or \code{NA} (the default) to
list the available examples.}

\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only.}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not.}

\item{display.mode}{The mode in which to display the example. Defaults to
\code{"auto"}, which uses the value of \code{DisplayMode} in the example's
\code{DESCRIPTION} file. Set to \code{"showcase"} to show the app code and
description with the running app, or \code{"normal"} to see the example without
code or commentary.}

\item{package}{The package in which to find the example (defaults to
\code{"shiny"}).

To provide examples in your package, store examples in the
\code{inst/examples-shiny} directory of your package. Each example should be
in its own subdirectory and should be runnable when \code{\link[=runApp]{runApp()}} is called
on the subdirectory. Example apps can include a \code{DESCRIPTION} file and a
\code{README.md} file to provide metadata and commentary about the example. See
the article on \href{https://shiny.posit.co/r/articles/build/display-modes/}{Display Modes}
on the Shiny website for more information.}
}
\description{
Launch Shiny example applications, and optionally, your system's web browser.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
  # List all available examples
  runExample()

  # Run one of the examples
  runExample("01_hello")

  # Print the directory containing the code for all examples
  system.file("examples", package="shiny")
}
}
