% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{is_device_mobile}
\alias{is_device_mobile}
\title{Is the user on a mobile device?}
\usage{
is_device_mobile()
}
\value{
Whether or not this user is on mobile
}
\description{
Convenience function that checks if the user's device is detected as mobile.
See \code{\link[=get_device]{get_device()}} for details.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    shinybrowser::detect(),
    "Are you on mobile?",
    textOutput("result")
  )
  server <- function(input, output, session) {
    output$result <- renderText({
      shinybrowser::is_device_mobile()
    })
  }
  shinyApp(ui, server)
}
}
