% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{encodePlot}
\alias{encodePlot}
\title{Renders a plot as a base64-encoded image}
\usage{
encodePlot(device, mimeType, width, height, plotFn)
}
\arguments{
\item{device}{Graphics device function, such as
\code{\link[grDevices:png]{grDevices::png}} or
\code{\link[grDevices:pdf]{grDevices::pdf}}}

\item{mimeType}{Mime type for the data produced by \code{device}}

\item{width}{Width of the plot in units applicable to \code{device}}

\item{height}{Height of the plot in units applicable to \code{device}}

\item{plotFn}{Function to call to perform the plot}
}
\value{
list with two keys, whose values can each be NULL:
\code{'plot'} is a plot in HTML img src form and \code{'data'} is a
data frame or other non-plot result.
}
\description{
Renders a plot as a base64-encoded image
}
\examples{
pdf <- encodePlot(grDevices::png, "image/png", 200, 300, function() {
  barplot(c(1, 2, 3, 4))
})
grDevices::png()  # workaround; you do not have to do this
}
