% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rerun_analysis.R
\name{rerun_analysis}
\alias{rerun_analysis}
\title{Re-run an previously executed shinymgr analysis}
\usage{
rerun_analysis(analysis_path)
}
\arguments{
\item{analysis_path}{File path to the RDS file that stores a previously
executed analysis.}
}
\value{
No return value, function launches shiny app
}
\description{
Re-run an previously executed shinymgr analysis given an RDS file
input from a previously saved analysis.
}
\details{
The function accepts a single argument that defines the file path to 
a saved shinymgr analysis (RDS file). This function will launch a shiny app, 
so can only be run during an interactive R session, in an R session with no other 
shiny apps running. 

The app that is launched contains 2 tabs. The first tab is called "The App" and 
will be visible when the re-run function is called. It contains a header with 
the app's name and a subheading of "Analysis Rerun". Below that, a disclaimer 
appears, indicating the app was produced from a saved analysis. You may need 
to scroll down using the vertical scroll bar in the rendering betlow to see that 
below this disclaimer is a fully functioning, identical copy of the shiny app 
used to generate the saved analysis.

The second tab, called "Analysis Summary", simply displays the structure of the 
saved analysis, excluding any saved source code. The structure of the analysis 
gives a high-level summary, including the values that can be entered in the app 
to reproduce results.
}
\section{More Info}{

The rerun_analysis() function is described in the "analyses" tutorial.
}

\section{Tutorials}{

The shinymgr learnr tutorials include, in order:
\enumerate{
  \item {\code{learnr::run_tutorial(name = "intro", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "shiny", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "app_modules", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "tests", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "database", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "shinymgr_modules", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "apps", package = "shinymgr")}} 
  \item {\code{learnr::run_tutorial(name = "analyses", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "reports", package = "shinymgr")}}
  \item {\code{learnr::run_tutorial(name = "deployment", package = "shinymgr")}}
}
}

\examples{
## Only run this example in interactive R sessions
if (interactive()) {

  # -----------------------------------------------------------------
  # Load the sample analysis from the shinymgr package and re-run it. 
  # -----------------------------------------------------------------

  # Get the path for the sample analysis from shinymgr
  analysis_path <- paste0(
    find.package('shinymgr'), 
    '/shinymgr/analyses/iris_explorer_Gandalf_2023_06_05_16_30.RDS'
  )

  # Re-run the sample analysis
  rerun_analysis(analysis_path)
  
}
}
\references{
\url{https://code.usgs.gov/vtcfwru/shinymgr}
}
\seealso{
Other analysis: 
\code{\link{restore_analysis}()}
}
\concept{analysis}
