% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title.R
\name{busy_window_title}
\alias{busy_window_title}
\title{Create Busy Browser Title}
\usage{
busy_window_title(title = "Running...")
}
\arguments{
\item{title}{String to give the window title.}
}
\value{
The browser tab title will change whenever the shiny application is in a 'busy' state.
}
\description{
Change the text in the browser tab whenever the shiny application is processing any server-side code.
}
\note{
Add \code{use_shiny_title} within the UI for \code{busy_window_title} to work.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "Initial Title",
    use_shiny_title(),
    busy_window_title("Sleeping..."),
    actionButton("button", "Click me for a 5 second busy title")
  )

  server <- function(input, output, session) {
    observeEvent(input$button, Sys.sleep(5))
  }

  shinyApp(ui, server)
}

}
