% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title.R
\name{change_window_title}
\alias{change_window_title}
\title{Change Browser Title}
\usage{
change_window_title(
  session = shiny::getDefaultReactiveDomain(),
  title = "Ready!",
  inactive_only = FALSE,
  revert_on_focus = inactive_only
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.
Default is \code{getDefaultReactiveDomain()}.}

\item{title}{String to give the window title}

\item{inactive_only}{Logical, whether or not the title should only change if the tab is not
active. Default is set to \code{FALSE}}

\item{revert_on_focus}{Logical, should the title revert back to the original title when the tab is in
focus/active again? Only works when \code{inactive_only = TRUE}.}
}
\value{
The browser tab title will change to the new specified title.
}
\description{
Change the text that is present in the browser tab.
}
\note{
Add \code{use_shiny_title} within the UI for \code{change_window_title} to work.
}
\examples{
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    title = "Initial Title",
    use_shiny_title(),
    actionButton("button", "Click me for a new title"),
    actionButton("button2", "Click me for a button when finished")
  )

  server <- function(input, output, session) {
    observeEvent(input$button, {
      change_window_title(session, "New Title")
    })

    observeEvent(input$button2, {
      Sys.sleep(3)
      change_window_title(session, "Sleep Finished", inactive_only = TRUE)
    })
  }

  shinyApp(ui, server)
}

}
