% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{sv_lt}
\alias{sv_lt}
\title{Validate that a field is less than a specified value}
\usage{
sv_lt(
  rhs,
  message_fmt = "Must be less than {rhs}.",
  allow_multiple = FALSE,
  allow_na = FALSE,
  allow_nan = FALSE,
  allow_inf = FALSE
)
}
\arguments{
\item{rhs}{The right hand side (RHS) value is to be used for the comparison
with the field value. The validation check will effectively be of the form
\verb{<field> < <rhs>}.}

\item{message_fmt}{The validation error message to use if the field fails the
validation test. Use the \code{"{rhs}"} string parameter to customize the
message, including what was set in \code{rhs}. While the default message uses
this string parameter, it is not required in a user-defined \code{message_fmt}
string.}

\item{allow_multiple}{If \code{FALSE} (the default), then the length of the input
vector must be exactly one; if \code{TRUE}, then any length is allowed
(including a length of zero; use \code{\link[=sv_required]{sv_required()}} if one or more values
should be required).}

\item{allow_na, allow_nan}{If \code{FALSE} (the default for both options), then any
\code{NA} or \code{NaN} element will cause validation to fail.}

\item{allow_inf}{If \code{FALSE} (the default), then any \code{Inf} or \code{-Inf} element
will cause validation to fail.}
}
\value{
A function suitable for use as an
\code{\link[=InputValidator]{InputValidator$add_rule()}} rule.
}
\description{
The \code{sv_lt()} function compares the field value to a specified value with the
\code{<} operator.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
library(shinyvalidate)

ui <- fluidPage(
  textInput("number", "Number")
)

server <- function(input, output, session) {
  
  # Validation rules are set in the server, start by
  # making a new instance of an `InputValidator()`
  iv <- InputValidator$new()

  # Basic usage: `sv_lt()` requires a value
  # to compare against the field value; a message
  # will be shown if the validation of
  # `input$number` fails
  iv$add_rule("number", sv_lt(10))

  # Finally, `enable()` the validation rules
  iv$enable()
}

shinyApp(ui, server)

}

}
\seealso{
The other comparison-based rule functions: \code{\link[=sv_gt]{sv_gt()}}, \code{\link[=sv_gte]{sv_gte()}},
\code{\link[=sv_lte]{sv_lte()}}, \code{\link[=sv_equal]{sv_equal()}}, and \code{\link[=sv_not_equal]{sv_not_equal()}}. The \code{\link[=sv_lte]{sv_lte()}} function may
be needed if the field value should also pass validation when equal to the
comparison value.

Other rule functions: 
\code{\link{compose_rules}()},
\code{\link{sv_between}()},
\code{\link{sv_email}()},
\code{\link{sv_equal}()},
\code{\link{sv_gte}()},
\code{\link{sv_gt}()},
\code{\link{sv_in_set}()},
\code{\link{sv_integer}()},
\code{\link{sv_lte}()},
\code{\link{sv_not_equal}()},
\code{\link{sv_numeric}()},
\code{\link{sv_optional}()},
\code{\link{sv_regex}()},
\code{\link{sv_required}()},
\code{\link{sv_url}()}
}
\concept{rule functions}
