% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkem_main_functions.R
\name{mvF}
\alias{mvF}
\alias{dmvF}
\alias{rmvF}
\title{The matrix F Distribution}
\usage{
dmvF(x, df1, df2, B, log = FALSE)

rmvF(n, df1, df2, B)
}
\arguments{
\item{x}{Positive definite matrix of quantities.}

\item{df1}{First degrees of freedom}

\item{df2}{Second degrees of freedom}

\item{B}{Positive definite scale matrix}

\item{log}{logical; if TRUE, density is given as log(p).}

\item{n}{Number of draws}
}
\value{
\code{dmvF} returns the probability density of the matrix F distribution.
\code{rmvF} returns a numeric array, say \code{R}, of dimension  \eqn{p \times p \times n}, where each element
\code{R[,,i]} is a positive definite matrix, a realization of the matrix F distribution.
}
\description{
Density and random generation for the matrix variate F distribution with first degrees
of freedom \code{df1}, second degrees of freedom \code{df2}, and scale matrix \code{B}.
}
\examples{

set.seed(20180222)
draws_F <- rmvF(n=1, df1=2, df2=4, B=diag(2))
dmvF(draws_F[,,1], df1=2, df2=4, B=diag(2))
}
\references{
Mulder and Pericchi (2018). The Matrix-F Prior for Estimating and Testing Covariance Matrices.
Bayesian Analysis, 13(4), 1193-1214. <https://doi.org/10.1214/17-BA1092>
}
