% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series.R
\name{setToken}
\alias{setToken}
\title{Set the query token}
\usage{
setToken(token)
}
\arguments{
\item{token}{A string that corresponds to the query token obtained.}
}
\description{
Set the token required to query series from \href{http://www.banxico.org.mx/SieInternet}{SIE}.
}
\details{
This configuration is required prior to any function call pertaining to this package.
The \href{https://www.banxico.org.mx/SieAPIRest}{API} used by siebanxicor requires that
every request made, be identified by a token. Otherwise the query will be rejected.
In order to work properly with this package is necessary to get a token
\href{https://www.banxico.org.mx/SieAPIRest/service/v1/token}{here}.

Before any request can be made with other functions, the obtained token must be set.
}
\examples{

# an own token must be obtained
token <- "d4b584b43a1413f56e5abdcc0f9e74db112ce9bb2f1580c80cb252f5a18b30a21"
setToken(token)

}
