% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigint.r
\name{sigint}
\alias{sigint}
\title{Estimating the parameters of the canonical discrete crisis bargaining game.}
\usage{
sigint(
  formulas,
  data,
  subset,
  na.action,
  fixed.par = list(),
  method = c("npl", "pl"),
  npl.maxit = 25,
  npl.tol = 1e-07,
  npl.trace = FALSE,
  start.beta,
  maxlik.method = "NR",
  phat,
  phat.formulas,
  pl.vcov = FALSE,
  phat.vcov,
  seed = 12345,
  maxlik.options = list()
)
}
\arguments{
\item{formulas}{a \code{Formula} object four variables on the left-hand side and 
seven (7) separate right-hand sides. See "Details" and examples below.}

\item{data}{a data frame containing the variables used to fit the model.
Each row of the data frame describes an individual game
\eqn{d = 1, 2, ..., D}. Each row \eqn{d}  should be a summary of all of the
within-game observations for game \eqn{d}. See "Details" for more
information.}

\item{subset}{an optional logical expression to specify a subset of 
observations to be used in fitting the model.}

\item{na.action}{how do deal with missing data (\code{NA}s).  Defaults to the 
\code{na.action} setting of \code{\link[base]{options}} (typically \code{na.omit}).}

\item{fixed.par}{a list with up to seven (7) named elements for normalizing payoffs to non-zero values.
Names must match a payoff name as listed in "Details."
Each named element should contain a single number that is the fixed (not estimated) value of that payoff.
For example, to fix each side's victory-without-fighting payoff to 1
 use \code{fixed.par=list(VA=1, VB=1)} and set their portions of the \code{formulas} to zero.
To normalize a payoff to zero, you only need to specify it has a zero in the \code{formulas}.}

\item{method}{whether to use the nested-pseudo-likelihood (\code{"npl"}, default) or
the pseudo-likelihood method for fitting the model. See "Details" for more 
information.}

\item{npl.maxit}{maximum number of outer-loop iterations to be used when fitting the NPL.
See "Details" for more information.}

\item{npl.tol}{Convergence criteria for the NPL. When the estimates change by
less than this amount, convergence is considered successful.}

\item{npl.trace}{logical. Should the NPL's progress be printed to screen?}

\item{start.beta}{starting values for the model coefficients as a single 
vector. If missing, random values are drawn from a normal distribution with mean
zero and standard deviation 0.05.}

\item{maxlik.method}{method used by  \code{\link[maxLik]{maxLik}}  to fit the
model. Default is Newton-Raphson (\code{"NR"}). See  \code{\link[maxLik]{maxLik}} 
for additional details. At this time only \code{"NR"}, \code{"BFGS"}, and \code{"Nelder-Mead"} are available.}

\item{phat}{a list containing two vectors: \code{PRhat} and \code{PFhat}.
These are the first-stage estimates that \eqn{B} resists a threat and that \eqn{A} 
follows through on a threat, respectively.
If missing, they will be estimated by a  \code{\link[randomForest]{randomForest}}  with default options.
See "Details" for more information.}

\item{phat.formulas}{if \code{phat} are  missing, you can supply formulas to 
estimate them. Should be a Formulas object containing no left-hand side and
1-2 right hand sides.  If  one right-hand side is given, the same 
covariates are used to estimate both \code{PRhat} and \code{PFhat}.  
Otherwise, the first RHS is used to generate \code{PRhat}, while the second RHS 
generates \code{PFhat}.
If no formulas are provided and \code{phat} is 
missing, all the covariates used in formulas argument and used here. See 
"Details" for more information.}

\item{pl.vcov}{number of bootstrap iterations to generate \code{phat.vcov}. 
If less than \code{0} or \code{FALSE} (default), the pseudo-likelihood 
covariance is not estimated.  Only used if \code{method = "pl"}.}

\item{phat.vcov}{a covariance matrix for the estimates \code{PRhat} and \code{PFhat}.
If missing and \code{pl.vcov = TRUE} and \code{phat} is missing, it will be 
estimated by bootstrapping the random forest used to fit \code{phat}.}

\item{seed}{integer.
Used to set the seed for the random forest and for drawing the the starting values.
The PL can be sensitive to starting value, so this makes results reproducible.
The NPL is less sensitive, but we always recommend checking the first order conditions.}

\item{maxlik.options}{a list of options to be passed to 
\code{\link[maxLik]{maxLik}}  for fitting the model.}
}
\value{
An object of class \code{sigfit}, containing:\describe{ 
  \item{\code{coefficients}}{A vector of estimated model parameters.}  
  \item{\code{vcov}}{Estimated variance-covariance matrix. When \code{pl.vcov = FALSE}, this slot is omitted.} 
  \item{\code{utilities}}{Each actor's utilities at the estimated values.}  
  \item{\code{fixed.par}}{The fixed utilities if specified in the call.}  
  \item{\code{logLik}}{Final log-likelihood value of the model.}
  \item{\code{gradient}}{First derivative values at the estimated parameters.}
  \item{\code{Phat}}{List of two elements 
     \itemize{ 
       \item \code{PRhat} The first stage estimates of the probability that 
     \eqn{B} resists (\code{method = "pl"}) or the final estimates that
     \eqn{B} resists (if \code{method = "npl"}) 
        \item \code{PFhat} The first stage estimates of the probability that 
     \eqn{A} stands firms given that \eqn{A} challenged (\code{method = "pl"}) or 
     the final estimates that \eqn{A} stands firms given that \eqn{A} challenged
     (if \code{method = "npl"})
     } 
     Note that \code{PRhat} will only be an equilibrium if \code{method = "npl"} and the NPL convergences
  }
  \item{\code{user.phat}}{Logical. Did the user provide phat?} 
  \item{\code{start.beta}}{The vector of starting values used in the PL optimization.}
  \item{\code{call}}{The call used to produce the object.}
  \item{\code{model}}{The data frame used to fit the model.}
  \item{\code{method}}{The method (\code{"pl"} or \code{"npl"}) used to fit the model.}
  \item{\code{maxlik.method}}{The optimization used by \code{maxLik} to fit the model.}
  \item{\code{maxlik.code}}{The convergence code returned by \code{maxLik}.}
  \item{\code{maxlik.message}}{The convergence message returned by \code{maxLik}.}
  }
Additionally, when \code{method = "npl"}, the following are also included in the \code{sigfit} object.\describe{
  \item{\code{npl.iter}}{Number of best response iterations used in fitting the NPL.}
  \item{\code{npl.eval}}{Maximum difference between the parameters at the last two NPL iterations. If the NPL method converged, this should be less than \code{npl.tol} specified in the function call.}
  \item{\code{eq.constraint}}{Maximum equilibrium constraint violation.}
  }
}
\description{
This function fits the Lewis and Schultz (2003) model to data using either 
the pseudo-likelihood (PL) or nested-pseudo likelihood (NPL) method from 
Crisman-Cox and Gibilisco (2018). Throughout, we refer to the data as
containing \eqn{D} games, where each game is  observed one or more times.
}
\details{
The model corresponds to an extensive-form, 
  discrete-crisis-bargaining game from Lewis and Schultz (2003): 
  \preformatted{ 
  .       A 
  .      / \ 
  .     /   \ 
  .    /     \
  .   S_A     B 
  .    0     / \
  .         /   \
  .        /     \
  .      V_A      A 
  .      C_B     / \ 
  .             /   \
  .            /     \
  .     W_A + e_A    a + e_a 
  .     W_B + e_B    V_B} 
  If \eqn{A} chooses not to challenge \eqn{B},
  then the game ends at the leftmost node (\eqn{SQ}) and payoffs are
  \eqn{S_A} and 0 to players \eqn{A} and \eqn{B}, respectively. If \eqn{A}
  challenges \eqn{B}, \eqn{B} can concede or resist.  If \eqn{B} concedes,
  the game ends at \eqn{CD} with payoffs \eqn{V_A} and \eqn{C_B}.  However,
  if \eqn{B} resists, \eqn{A} decides to stand firm, which ends the game at
  \eqn{SF} with payoffs \eqn{W_A + \epsilon_A} and \eqn{W_B + \epsilon_B}.
  Finally, if \eqn{A} decides to back down in the face of \eqn{B}'s
  resistance, then the game ends at the rightmost node \eqn{BD}, with payoffs
  \eqn{a + \epsilon_a} and \eqn{V_B}.
  
  The seven right-hand formulas that are specified in the formula argument 
  correspond to the regressors to be placed in \eqn{S_A, V_A, C_B, W_A, W_B, 
  a}, and \eqn{V_B}, respectively. The model is unidentified if any regressor
  (including a constant term) is included in all the formulas for each player
  (Lewis and Schultz 2003). Often the easiest way to meet this requirement is
  set one formula per player  to 0. When an identification problem is
  detected, an error is issued. For example, the syntax for the formula
  argument could be:
  
  \code{formulas = sq + cd + sf + bd ~ x1 + 0 | x2 | x2 | x1 + x2 | x1 | 1 | 0)}

  Where: \itemize{
      \item \code{sq + cd + sf + bd} are the tallies of how many
  times each outcome is observed for each observation.  When the game is only
  observed once, that observation will be a 1 and three 0s.  When the game is
  observed multiple times, these variables should count the number of times 
  each outcome is observed.  They need to be in the order of \eqn{SQ}, 
  \eqn{CD}, \eqn{SF}, \eqn{BD}.
   \item \eqn{S_A} is a function of the variable \code{x1} and no constant term.
   \item \eqn{V_A} is a function of the variable \code{x2} and a constant term.
   \item \eqn{C_B} is a function of the variable \code{x2} and a constant term.
   \item \eqn{W_A} is a function  of the variables \code{x1}, \code{x2} and a constant term.
   \item \eqn{W_B} is a function of the variable  \code{x1} and a constant term.
  \item \eqn{a} is a constant term.
  \item \eqn{V_B} is fixed to 0 (or a non-zero value set by \code{fixed.par}. }


  Each row of the data frame should be a summary of the covariates and outcomes associated with that particular game.
  When each game is observed only once, then this will resemble an ordinary dyad-time data frame.
  However, if there are multiple observations per game, then each row should be a summary of all the data associated
  with that game.
  For example, if there are \eqn{D} games in the data, where each is observed \eqn{T_d} times, then the data frame
  should have \eqn{D} rows.
  The four columns making up the dependent variable will denote the frequencies of each outcome for game \eqn{d},
  such that \code{sq}\eqn{_d} + \code{cd}\eqn{_d} + \code{sf}\eqn{_d} + \code{bd}\eqn{_d = T_d}.
  The covariates in row \eqn{d} should be summary statistics for the exogenous variables (e.g., mean, median, mode, first observation).
  
   
  The model is first fit using a pseudo-likelihood estimator.  This approach 
  requires first stage estimation of the probability that \eqn{B} resists and
  the probability that \eqn{A} fights conditional on \eqn{B} choosing to 
  resist. These first stage estimates should be flexible and we recommend
  that users fit a flexible semi-parametric or non-parametric model to
  produce them. If these estimates are produced by the analyst prior to using
  this function, then they can be provided by providing a list to the
  \code{phat} argument. This list should contain two named elements \itemize{
  \item \code{PRhat} is the probability that \eqn{B} resists.  This should be
  a vector of probabilities with one estimated probability for each
  observation. \item \code{PFhat} is the probability that \eqn{A} stands firm
  conditional on \eqn{B} resisting.  This should be a vector of probabilities
  with one estimated probability for each observation. }
  
  
  If the user leaves the \code{phat} argument empty, then these first-stage 
  estimates are produced internally using the 
  \code{\link[randomForest]{randomForest}} function.
  Users wanting to use the
  random forest, can supply a formula for it using the argument 
  \code{phat.formulas}.
  This argument can take a formula with nothing on the 
  left-hand side and 1-2 right-hand sides.
  If two right-hand sides are 
  provided then the first is used to generate \code{PRhat}, and the second is
  used for \code{PFhat}.
  If only one right-hand side is provided, it is used
  for both. Some examples: \itemize{
       \item \code{phat.formulas = ~ x1 + x2} 
  predict \code{PRhat} and \code{PFhat} using \code{x1} and \code{x2}.
       \item \code{phat.formulas = ~ x1 + x2 | x1 + x2} predict \code{PRhat} and 
  \code{PFhat} using \code{x1} and \code{x2}
       \item \code{phat.formulas = ~ x1 + x2 | x1 } predict \code{PRhat}  using \code{x1} and \code{x2}, but
  predict \code{PFhat} using only \code{x1}. }
  If both \code{phat} and \code{phat.formula} are missing, then a random forest is fit using all the 
  exogenous variables listed in the formulas argument
  
  If \code{method = "npl"}, then estimation continues.  
  For each iteration of the NPL, the estimates of \code{PRhat} and \code{PFhat} are updated
  by one best-response iteration using the current parameter estimates.
  The model is then refit using these updated choice probabilities.
  This process continues until the maximum absolute change in
  parameters and choice probabilities is less than \code{npl.tol} (default, \code{1e-7}), or
  the number of outer iterations exceeds \code{npl.maxit} (default, \code{25}).
  In the latter case, a warning is produced.
  
  
  If pseudo-likelihood (\code{method="pl"}) is used, then 
  \code{pl.vcov} is checked.
  There are four possibilities here: 
  \itemize{
    \item \code{pl.vcov = FALSE} (default), then no covariance matrix or
  standard errors are returned, only the point estimates. 
    \item \code{pl.vcov > 0} and \code{phat.vcov} is supplied, 
  then \code{phat.vcov} is used to estimate the PL's covariance matrix. 
    \item  \code{pl.vcov > 0}, \code{phat.vcov} is missing, and \code{phat} 
  is missing, then the random forest used to estimate \code{PRhat} and
  \code{PFhat} is bootstrapped (simple, nonparametric bootstrap)  \code{pl.vcov} times.
    \item \code{pl.vcov > 0}, \code{phat.vcov} is missing, and \code{phat} is not
  missing, then an error is returned. 
  }
}
\examples{
data("sanctionsData")
f1 <- sq+cd+sf+bd ~ sqrt(senderecondep) + senderdemocracy + contig + ally -1|#SA
                    anticipatedsendercosts|#VA
                    sqrt(targetecondep) + anticipatedtargetcosts + contig + ally|#CB
                    sqrt(senderecondep) + senderdemocracy + lncaprat | #barWA
                    targetdemocracy + lncaprat| #barWB
                    senderdemocracy| #bara
                    -1#VB

## Using Nested-Pseudo Likelihood  with default first stage     
\dontrun{            
fit1 <- sigint(f1, data=sanctionsData, npl.trace=TRUE)
summary(fit1)
}


## Using Pseudo Likelihood with user supplied first stage
Phat <- list(PRhat=sanctionsData$PRnpl, PFhat=sanctionsData$PFnpl)
fit2 <- sigint(f1, data=sanctionsData, method="pl", phat=Phat)
summary(fit2)

## Using Pseudo Likelihood with user made first stage and user covariance
## SIGMA is a bootstrapped first-stage covariance matrix (not provided)
\dontrun{
fit3 <- sigint(f1, data=sanctionsData, method="pl", phat=Phat, phat.vcov=SIGMA, pl.vcov=TRUE)
summary(fit3)
}

## Using Pseudo Likelihood with default first stage and 
## bootstrapped standard errors for the first stage covariance
\dontrun{
fit4 <- sigint(f1, data=sanctionsData, method="pl", pl.vcov=25) 
summary(fit4)
}

}
\references{
Casey Crisman-Cox and Michael Gibilisco. 2019. "Estimating 
Signaling Games in International Relations: Problems and Solutions."
\emph{Political Science Research and Methods}. Online First.

Jeffrey B. Lewis and Kenneth A. Schultz.  2003.  "Revealing
Preferences: Empirical Estimation of a Crisis Bargaining Game with
Incomplete Information."  \emph{Political Analysis} 11:345--367.
}
