% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttons.R
\name{sg_button}
\alias{sg_button}
\title{Buttons}
\usage{
sg_button(
  sg,
  event,
  ...,
  position = "top",
  class = "btn btn-default",
  tag = htmltools::tags$button,
  id = NULL
)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{event}{Event the button triggers, see valid events.}

\item{...}{Content of the button, complient with \code{htmltools}.}

\item{position}{Position of button, \code{top} or \code{bottom}.}

\item{class}{Button \code{CSS} class, see note.}

\item{tag}{A Valid \code{htmltools} tags function.}

\item{id}{A valid CSS id.}
}
\value{
An object of class \code{htmlwidget} which renders the visualisation on print.
}
\description{
Add buttons to your graph.
}
\details{
You can pass multiple events as a vector, see examples. You can also pass multiple buttons.
}
\note{
The default class (\code{btn btn-default}) works with Bootstrap 3 (the default framework for Shiny and R markdown).
}
\section{Events}{

\itemize{
  \item{\code{force_start}}
  \item{\code{force_stop}}
  \item{\code{noverlap}}
  \item{\code{drag_nodes}}
  \item{\code{relative_size}}
  \item{\code{add_nodes}}
  \item{\code{add_edges}}
  \item{\code{drop_nodes}}
  \item{\code{drop_edges}}
  \item{\code{animate}}
  \item{\code{export_svg}}
  \item{\code{export_img}}
  \item{\code{progress}}
  \item{\code{read_exec}}
}
}

\examples{
nodes <- sg_make_nodes() 
edges <- sg_make_edges(nodes)

# Button starts the layout and stops it after 3 seconds
sigmajs() \%>\% 
  sg_nodes(nodes, id, size) \%>\% 
  sg_edges(edges, id, source, target) \%>\% 
  sg_force_start() \%>\% 
  sg_force_stop(3000) \%>\% 
  sg_button(c("force_start", "force_stop"), "start layout")
  
# additional nodes
nodes2 <- sg_make_nodes()
nodes2$id <- as.character(seq(11, 20))

# add delay
nodes2$delay <- runif(nrow(nodes2), 500, 1000)

sigmajs() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_add_nodes(nodes2, delay, id, label, size, color) \%>\% 
  sg_force_start() \%>\% 
  sg_force_stop(3000) \%>\% 
  sg_button(c("force_start", "force_stop"), "start layout") \%>\% 
  sg_button("add_nodes", "add nodes")

}
