% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{find_matching_conditional_betas}
\alias{find_matching_conditional_betas}
\alias{find_ROC_matching_ab}
\title{Find beta shape parameters matching the conditional distributions.}
\usage{
find_matching_conditional_betas(modelPredictions, yValues, ..., yTarget = TRUE)

find_ROC_matching_ab(modelPredictions, yValues, ..., yTarget = TRUE)
}
\arguments{
\item{modelPredictions}{numeric predictions (not empty), ordered (either increasing or decreasing)}

\item{yValues}{truth values (not empty, same length as model predictions)}

\item{...}{force later arguments to bind by name.}

\item{yTarget}{value considered to be positive.}
}
\value{
beta curve shape parameters
}
\description{
Based on \url{https://win-vector.com/2020/09/13/why-working-with-auc-is-more-powerful-than-one-might-think/}. Used to find
one beta distribution on positive examples, and another on negative examples.
}
\examples{

d <- rbind(
  data.frame(x = rbeta(1000, shape1 = 6, shape2 = 4), y = TRUE),
  data.frame(x = rbeta(1000, shape1 = 2, shape2 = 3), y = FALSE)
)
find_matching_conditional_betas(modelPredictions = d$x, yValues = d$y)
# should be near
# shape1_pos shape2_pos shape1_neg shape2_neg
# 6          4          2          3
#
# # How to land all as variables
# unpack[shape1_pos, shape2_pos, shape1_neg, shape2_neg] <-
#    find_ROC_matching_ab(modelPredictions = d$x, yValues = d$y)

}
