% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_area.R
\name{within_area}
\alias{within_area}
\title{Determine Whether Lattice Points are Within or Without a Random Set}
\usage{
within_area(grid.centers, radii, event.xcoord, event.ycoord)
}
\arguments{
\item{grid.centers}{Output from \code{generate.grid()} that specifies the 
coordinates of the lattice locations in native space.}

\item{radii}{A vector of radii values.}

\item{event.xcoord, event.ycoord}{Paired vectors specifying the x- and 
y- coordinates, respectively, of each 'event' from the Poisson process.}
}
\value{
A data frame with lattice x- and y- coordinates, and a binary vector
where 1 indicates the location is within the random set, and 0 indicates 
the location is without the random set.
}
\description{
Determine whether locations in the image/lattice (from \code{generate.grid})
are within or without the union of a random set generated by 
\code{sim2D_HPPP_coords()}. If the Euclidean distance between a lattice 
location and any 'event' is less than the radius about the 'event', then 
the location is said to be within the random set. Otherwise, it is without
the random set.
}
