% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createLinkagePlan.R
\name{createLinkagePlan}
\alias{createLinkagePlan}
\title{Creates linkage plan}
\usage{
createLinkagePlan(forms, J, C, forms.linked, wrap.around = FALSE)
}
\arguments{
\item{forms}{number of forms}

\item{J}{number of items per form}

\item{C}{number of items in common between two forms}

\item{forms.linked}{maximum number of forms linked to one form}

\item{wrap.around}{if \code{TRUE}, links last form to first form}
}
\value{
matrix with the number of items in common between two forms
}
\description{
Creates linkage plan
}
\examples{
# Linkage plan for 10 forms, 40 items per form, 5 items in common between
# each pair of forms, and with each form being connected at most to its 4
# closest neighbors.
createLinkagePlan(10, 40, 5, 4)
}
