% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effTransform.R
\name{effTransform}
\alias{effTransform}
\alias{effTransformAll}
\title{Transform effectiveness distributions towards a expected value}
\usage{
effTransform(eff, mean, abs.tol = 1e-05)

effTransformAll(effs, means, abs.tol = 1e-05, silent = TRUE)
}
\arguments{
\item{eff}{the distribution to transform.}

\item{mean}{the target expected value to transform to. If missing, defaults to the mean in the
data used to fit \code{eff}, if any.}

\item{abs.tol}{the absolute tolerance of the transformation.}

\item{effs}{the list of distributions to transform.}

\item{means}{the vector of target expected values to transform to. If missing, defaults to the
means in the data used to fit \code{effs}, if any.}

\item{silent}{logical: should the report of error messages be suppressed?}
}
\value{
an effectiveness distribution of class \code{eff.cont.trans} or \code{eff.disc.trans},
  depending on the type of distribution.
}
\description{
Transforms the given effectiveness distribution such that its expected value matches a predefined
value. For details, please refer to section 3.4 of (Urbano and Nagler, 2018).
}
\details{
\code{effTransformAll} does the same but for a list of distributions and target means.
}
\examples{
e <- effCont_beta(web2010ap[,1])
e2 <- effTransform(e, 0.12)
c(e$mean, e2$mean)
plot(e)
plot(e2)

\donttest{
# transform a list of distributions to the observed means
ee <- effContFitAndSelect(web2010ap[,1:5])
ee2 <- effTransformAll(ee)
obsmeans <- colMeans(web2010ap[,1:5])
sapply(ee, function(e)e$mean) - obsmeans
sapply(ee2, function(e)e$mean) - obsmeans
}
}
\references{
J. Urbano and T. Nagler. (2018). Stochastic Simulation of Test Collections:
  Evaluation Scores. ACM SIGIR.
}
