% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_stratified_ITS.R
\name{generate_fake_grouped_data}
\alias{generate_fake_grouped_data}
\title{A fake DGP with time varying categorical covariate for illustrating the code.}
\usage{
generate_fake_grouped_data(
  t_min,
  t0,
  t_max,
  method = c("complex", "linear", "jersey")
)
}
\arguments{
\item{t_min}{Index of first month}

\item{t0}{last pre-policy timepoint}

\item{t_max}{Index of last month}

\item{method}{Type of post-stratification structure to generate (three designs of 'complex', 'linear' and 'jersey' were originally concieved of when designing simulation studies with different types of structure).}
}
\value{
Dataframe of fake data, with one row per group per time period.
}
\description{
This code makes synthetic grouped data that can be used to illustrate
benefits of post stratification.
}
\examples{
fdat = generate_fake_grouped_data(t_min=-5,t_max=10, t0 = 0)
table( fdat$month )
table( fdat$type )
}
