% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{sim_test_data_patient}
\alias{sim_test_data_patient}
\title{simulate patient event reporting test data}
\usage{
sim_test_data_patient(
  .f_sample_max_visit = function() rnorm(1, mean = 20, sd = 4),
  .f_sample_event_per_visit = function(max_visit) rpois(max_visit, 0.5)
)
}
\arguments{
\item{.f_sample_max_visit}{function used to sample the maximum number of events,
Default: function() rnorm(1, mean = 20, sd = 4)}

\item{.f_sample_event_per_visit}{function used to sample the events for each visit,
Default: function(x) rpois(x, 0.5)}
}
\value{
vector containing cumulative events
}
\description{
helper function for \code{\link[=sim_test_data_study]{sim_test_data_study()}}
}
\details{
""
}
\examples{
replicate(5, sim_test_data_patient())
replicate(5, sim_test_data_patient(
    .f_sample_event_per_visit = function(x) rpois(x, 1.2))
  )
replicate(5, sim_test_data_patient(
    .f_sample_max_visit = function() rnorm(1, mean = 5, sd = 5))
  )
}
\keyword{internal}
