% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_test_data.R
\name{sim_test_data_study}
\alias{sim_test_data_study}
\title{simulate study test data}
\usage{
sim_test_data_study(
  n_pat = 1000,
  n_sites = 20,
  ratio_out = 0,
  factor_event_rate = 0,
  max_visit_mean = 20,
  max_visit_sd = 4,
  event_rates = dgamma(seq(1, 20, 0.5), shape = 5, rate = 2) * 5 + 0.1,
  event_names = c("event"),
  study_id = "A"
)
}
\arguments{
\item{n_pat}{integer, number of patients, Default: 1000}

\item{n_sites}{integer, number of sites, Default: 20}

\item{ratio_out}{ratio of sites with outlier, Default: 0}

\item{factor_event_rate}{event reporting rate factor for site outlier, will
modify mean event per visit rate used for outlier sites. Negative Values
will simulate under-reporting, positive values over-reporting, e.g. -0.4 ->
40\% under-reporting, +0.4 -> 40\% over-reporting Default: 0}

\item{max_visit_mean}{mean of the maximum number of visits of each patient,
Default: 20}

\item{max_visit_sd}{standard deviation of maximum number of visits of each
patient, Default: 4}

\item{event_rates}{list or vector with visit-specific event rates. Use list
for multiple event names, Default: dgamma(seq(1, 20, 0.5), shape = 5, rate =
2) * 5 + 0.1}

\item{event_names}{vector, contains the event names, default = "event"}

\item{study_id}{character, Default: "A"}
}
\value{
tibble with columns site_id, patient_id, is_out, max_visit_mean,
max_visit_sd, event_per_visit_mean, visit, n_event
}
\description{
evenly distributes a number of given patients across a number of
given sites. Then simulates event reporting of each patient reducing the
number of reported events for patients distributed to event-under-reporting
sites.
}
\details{
maximum visit number will be sampled from normal distribution with
characteristics derived from max_visit_mean and max_visit_sd, while the
events per visit will be sampled from a poisson distribution described by
events_per_visit_mean.
}
\examples{
set.seed(1)
# no outlier
df_visit <- sim_test_data_study(n_pat = 100, n_sites = 5)
df_visit[which(df_visit$patient_id == "P000001"),]

# under-reporting outlier
df_visit <- sim_test_data_study(n_pat = 100, n_sites = 5,
    ratio_out = 0.2, factor_event_rate = -0.5)
df_visit[which(df_visit$patient_id == "P000001"),]

# constant event rates
sim_test_data_study(n_pat = 100, n_sites = 5, event_rates = 0.5)

# non-constant event rates for two event types
event_rates_ae <- c(0.7, rep(0.5, 8), rep(0.3, 5))
event_rates_pd <- c(0.3, rep(0.4, 6), rep(0.1, 5))

sim_test_data_study(
n_pat = 100,
n_sites = 5,
event_names = c("ae", "pd"),
event_rates = list(event_rates_ae, event_rates_pd)
)

}
