% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{attribute_inv_bijection}
\alias{attribute_inv_bijection}
\title{Perform an Inverse Bijection of an Integer to Attribute Pattern}
\usage{
attribute_inv_bijection(K, CL)
}
\arguments{
\item{K}{Number of Attributes.}

\item{CL}{An \code{integer} between \eqn{0} and \eqn{2^{K-1}}}
}
\value{
A \eqn{K}-dimensional vector with an attribute pattern corresponding
to \code{CL}.
}
\description{
Convert an integer between \eqn{0} and \eqn{2^{K-1}} to
\eqn{K}-dimensional attribute pattern.
}
\examples{
## Construct an attribute inversion bijection ----
inv_biject1 = attribute_inv_bijection(5, 1)
inv_biject2 = attribute_inv_bijection(5, 2)
}
\seealso{
\code{\link[=attribute_bijection]{attribute_bijection()}}
}
\author{
Steven Andrew Culpepper and James Joseph Balamuta
}
