% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fam_ancestors.R
\name{fam_ancestors}
\alias{fam_ancestors}
\title{Construct an ancestors-only pedigree for one person \code{G}-generations deep}
\usage{
fam_ancestors(G)
}
\arguments{
\item{G}{The desired number of generations.
\code{G=1} returns a trivial pedigree with a single individual; \code{G=2} an individual and its two parents; \code{G=3} an individual, its parents and grandparents, etc.}
}
\value{
A list with two named elements:
\itemize{
\item \code{fam}: a tibble describing the pedigree, with the following columns
\itemize{
\item \code{id}: The ID of each individual, a string in the format "g-i" joining with a dash the generation number ("g", numbered backward in time) and the individual number within the generation ("i").
\item \code{pat}: The paternal ID.  For individual "g-i" parent is (g+1)"-"(2*i-1), except for last generation it is \code{NA} (their parents are missing).
\item \code{mat}: The maternal ID.  For individual "g-i" parent is (g+1)"-"(2*i), except for last generation it is \code{NA} (their parents are missing).
\item \code{sex}: 1 (male) for all odd-numbered individuals, 2 (female) for even-numbered individuals, consistent with pedigree structure.  Side-effect is first-generation individual ("1-1") is always male (edit afterwards as desired).
}
\item \code{ids}: A list containing vectors of IDs separated by generation, but here starting from the last generation (highest "g"), to be consistent with output of \code{\link[=sim_pedigree]{sim_pedigree()}} and the expected input of all \verb{*_last_gen} functions.
}
}
\description{
Creates an idealized pedigree listing all ancestors of one individual starting from \code{G} generations ago, without inbreeding (a binary tree).
IDs are automatically generated strings indicating generation and individual number within generation.
Useful for simple simulations of individuals with explicit ancestors.
}
\examples{
# construct the 8-generation ancestor tree of one individual:
data <- fam_ancestors( 8 )
# this is the pedigree
fam <- data$fam
# and this is the handy list of IDs by discrete generation,
# used by `*_last_gen` functions to reduce memory usage
ids <- data$ids

}
\seealso{
\code{\link[=sim_pedigree]{sim_pedigree()}} to simulate a random pedigree with a given number of generations, generation sizes, and other parameters.
}
