% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{analyze.simstudy.chisq.test.gf}
\alias{analyze.simstudy.chisq.test.gf}
\title{analyze.simstudy.chisq.test.gf}
\usage{
analyze.simstudy.chisq.test.gf(
  test.statistics.chisq.test.gf,
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975)
)
}
\arguments{
\item{test.statistics.chisq.test.gf}{A list containing summary information
for fitting chi squared tests of goodness of fit. The structure is in the
form
returned by the function \code{simitation::sim.chisq.test.gf()}.}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence
level (1 - significance level). Default is 0.95.}

\item{the.quantiles}{A numeric vector of values between 0 and 1. Summary
statistics to analyze the tests will return the specified quantiles. Default
values are c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975).}
}
\value{
A list containing the following elements:
\itemize{
  \item stat.summary: Summary statistics for the test statistics.
  \item p.value.summary: Proportions of tests that rejected and did not
  reject the null hypothesis.
}
}
\description{
This function analyzes the results of a simulated chi-squared
test of goodness of fit.
}
\examples{

 simdat.chisq.gf <- sim.chisq.gf(n = 100, values = LETTERS[1:4],
 prob = c(0.4, 0.3, 0.2, 0.1), num.experiments = 2, experiment.name =
  "experiment_id", value.name = "classification", seed = 31)
test.statistics.chisq.test.gf <- sim.chisq.test.gf(simdat.chisq.gf =
simdat.chisq.gf, hypothesized.probs = c(0.25, 0.3, 0.15, 0.3),
correct = FALSE, experiment.name = "experiment_id",
value.name = "classification")

analysis.chisq.gf <-
analyze.simstudy.chisq.test.gf(test.statistics.chisq.test.gf =
test.statistics.chisq.test.gf, conf.level = 0.95,
the.quantiles = c(0.25, 0.75))
}
