% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.norm}
\alias{sim.norm}
\title{Internal function for Normal Distribution Simulation}
\usage{
sim.norm(
  n.values,
  mean.values,
  sd.values,
  num.experiments = 1,
  variable.names = NULL,
  seed = 1978,
  vstr = 3.6
)
}
\arguments{
\item{n.values}{A numeric vector indicating the number of values to be simulated for each normal distribution.}

\item{mean.values}{A numeric vector indicating the mean values for each normal distribution.}

\item{sd.values}{A numeric vector indicating the standard deviation values for each normal distribution.}

\item{num.experiments}{A single integer indicating the number of experiments to simulate. Default is 1.}

\item{variable.names}{A character vector with names for the variables. If NULL, default names "x1", "x2", ... will be used.}

\item{seed}{An integer to set as the seed for reproducibility. Default is 1978.}

\item{vstr}{A character string specifying the RNG version. Default is "3.6".}
}
\value{
A data.table containing the simulated data.
}
\description{
Simulates data from normal distributions given specified parameters.
}
