% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{sim.prop}
\alias{sim.prop}
\title{sim.prop}
\usage{
sim.prop(
  n,
  p = 0.5,
  num.experiments = 1,
  experiment.name = "experiment",
  value.name = "x",
  seed = 2470,
  vstr = 3.6
)
}
\arguments{
\item{n}{A numeric value for the number of observations in each experiment.}

\item{p}{A numeric value for the probability of success.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{value.name}{A character value providing the name for the simulated values.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A data.table containing simulated values based on the probability of success for each experiment. The output will have two columns: one indicating the experiment and another containing the simulated values.
}
\description{
sim.prop
}
\examples{
simdat.prop <- sim.prop(n = 30, p = 0.45, num.experiments = 2,
 experiment.name = "simulation_id", value.name = "success", seed = 104)
}
