% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.chisq.test.gf}
\alias{simstudy.chisq.test.gf}
\title{simstudy.chisq.test.gf}
\usage{
simstudy.chisq.test.gf(
  n,
  values,
  actual.probs,
  hypothesized.probs = NULL,
  num.experiments = 1,
  conf.level = 0.95,
  correct = TRUE,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  value.name = "x",
  seed = 7261,
  vstr = 3.6
)
}
\arguments{
\item{n}{A numeric value for the number of observations in each experiment.}

\item{values}{A vector of values specifying the sample space.}

\item{actual.probs}{A vector of probabilities used to simulate the values.}

\item{hypothesized.probs}{A vector of hypothesized probabilities for the values.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence level (1 - significance level).}

\item{correct}{See help(chisq.test).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{value.name}{A character value providing the name for the simulated values.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing three elements:
   'simdat': A data frame of the simulated data based on chi-squared distributions.
  'test.statistics': A data frame or data.table containing the results of chi-squared tests performed on the simulated data.
  'sim.analysis': Summary statistics or analysis results from the simulated chi-squared tests.
}
\description{
simstudy.chisq.test.gf
}
\examples{
study.chisq.gf <- simstudy.chisq.test.gf(n = 75, values = LETTERS[1:4],
actual.probs = c(0.3, 0.3, 0.2, 0.2),
hypothesized.probs = rep.int(x = 0.25, times = 4),
num.experiments = 2, conf.level = 0.95, correct = FALSE,
the.quantiles = c(0.25, 0.75), experiment.name = "experiment_id",
value.name = "classification", seed = 61)

}
