% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simitation.R
\name{simstudy.lm}
\alias{simstudy.lm}
\title{simstudy.lm}
\usage{
simstudy.lm(
  the.steps,
  n,
  num.experiments,
  the.formula,
  conf.level = 0.95,
  the.quantiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  experiment.name = "experiment",
  step.split = "~",
  coef.name = "Coefficient",
  estimate.name = "Estimate",
  lm.p.name = "Pr(>|t|)",
  f.p.name = "f.pvalue",
  seed = 41,
  vstr = 3.6
)
}
\arguments{
\item{the.steps}{A character vector of variables to simulate.  The variables are simulated in the order specified.  Later variables can be generated to depend on earlier variables.  The possible specifications include:
Normal "X ~ N(100, 5)" with the mean and SD.
Uniform "X ~ U(0, 100)" with the minimum and maximum.
Poisson "X ~ Poisson(3)" with the mean.
Binary "X ~ Binary(0.5)" with the probability of success.
Binomial "X ~ Bin(10, 0.2)" with the number of trials and probability of success.
Categorical "Diet ~ sample(('Light', 'Moderate', 'Heavy'), (0.2, 0.45, 0.35))" with the values in the first set of parentheses and their respective probabilities in the second.
Regression "Healthy.Lifestyle ~ logistic(log(0.45) - 0.1 * (Age -45) + 0.05 * Female + 0.01 * Health.Percentile + 0.5 * Exercise.Sessions - 0.1 * (Diet == 'Moderate') - 0.4 * (Diet == 'Heavy'))"
Linear Regression  "Weight ~ lm(150 - 15 * Female + 0.5 * Age - 0.1 * Health.Percentile - 0.2 * Exercise.Sessions  + 5 * (Diet == 'Moderate') + 15 * (Diet == 'Heavy') - 2 * Healthy.Lifestyle + N(0, 10))".  Note that the error term may be specified symbolically with any of the above distributions.}

\item{n}{A numeric value for the number of observations in each experiment.}

\item{num.experiments}{A numeric value representing the number of simulated experiments.}

\item{the.formula}{A formula object or character value specifying the formula for the regression model.}

\item{conf.level}{A numeric value between 0 and 1 representing the confidence level (1 - significance level).}

\item{the.quantiles}{A numeric vector of values between 0 and 1.  Summary statistics to analyze the tests will return the specified quantiles.}

\item{experiment.name}{A character value providing the name for the column identifying the experiment.}

\item{step.split}{A character value that separates the name of the variable to be simulated (left side) from its distribution (right side).  Using the.steps = "X ~ N(0,1)" with step.split = "~" will generate a variable named X from a standard Normal distribution.}

\item{coef.name}{A character value specifying the column of the.coefs that contains the names of the input variables of the linear regression model.}

\item{estimate.name}{A character value specifying the column of the.coefs that contains the estimated coefficients of the linear regression model.}

\item{lm.p.name}{A character value specifying the column of the.coefs that contains the p-values for the tests of the estimated coefficients of the linear regression model.}

\item{f.p.name}{A character value specifying the column of summary.stats that contains the p-value for the linear regression model's F test.}

\item{seed}{A single numeric value, interpreted as an integer, or NULL.   See help(set.seed).}

\item{vstr}{A character string containing a version number, e.g., "1.6.2". The default RNG configuration of the current R version is used if vstr is greater than the current version.  See help(set.seed).}
}
\value{
A list containing four elements:
  'the.steps': The steps or processes defined for the simulation, detailing the structure and relationships among the variables.
  'simdat': A data frame of the simulated data based on linear regression.
  'statistics: A data frame containing regression statistics, coefficient estimates, and related results.
  'sim.analysis': Summary statistics or analysis results from the simulated linear regression.
}
\description{
simstudy.lm
}
\examples{


step.age <- "Age ~ N(45, 10)"
step.female <- "Female ~ binary(0.53)"
step.health.percentile <- "Health.Percentile ~ U(0,100)"
step.exercise.sessions <- "Exercise.Sessions ~ Poisson(2)"
step.diet <- "Diet ~ sample(('Light', 'Moderate', 'Heavy'),
(0.2, 0.45, 0.35))"

step.healthy.lifestyle <- "Healthy.Lifestyle ~ logistic(log(0.45) - 0.1 *
(Age -45) + 0.05 * Female + 0.01 * Health.Percentile + 0.5 *
Exercise.Sessions - 0.1 * (Diet == 'Moderate') - 0.4 *
(Diet == 'Heavy'))"

step.weight <- "Weight ~ lm(150 - 15 * Female + 0.5 * Age - 0.1 *
Health.Percentile - 0.2 * Exercise.Sessions  + 5 * (Diet == 'Moderate') +
15 * (Diet == 'Heavy') - 2 * Healthy.Lifestyle + N(0, 10))"

the.steps <- c(step.age, step.female, step.health.percentile,
step.exercise.sessions, step.diet, step.healthy.lifestyle,
step.weight)

study.lm <- simstudy.lm(the.steps = the.steps, n = 100,
num.experiments = 2,
the.formula = Weight ~ Age + Female + Health.Percentile +
Exercise.Sessions + Healthy.Lifestyle,
conf.level = 0.95, the.quantiles = c(0.25, 0.75),
experiment.name = "sim", seed = 11)
}
