% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessories.R
\name{getSampledAbund}
\alias{getSampledAbund}
\title{Sample abundance values}
\usage{
getSampledAbund(
  abundDt,
  logOdds = FALSE,
  family = c("gaussian", "negbinom", "bernoulli", "poisson"),
  inplace = FALSE
)
}
\arguments{
\item{abundDt}{\code{data.table} of expected abundance. If \code{family} is 'gaussian',
required columns are \code{feature}, \code{sample}, \code{mu}, and \code{sd}. If \code{family} is
'negbinom', required columns are \code{feature}, \code{sample}, \code{mu}, \code{dispFunc},
\code{cond}, and \code{group}. If \code{family} is 'bernoulli' or 'poisson', required
columns are \code{feature}, \code{sample}, and \code{mu}.}

\item{logOdds}{Logical for whether \code{mu} corresponds to log-odds. Only used if
\code{family} is 'bernoulli'.}

\item{family}{Character string for the family of distributions from which
to sample the abundance values. \code{simphony} will give a warning if it tries
to sample from a distribution outside the region in which the distribution
is defined: \eqn{\mu < 0} for negative binomial and Poisson, and
\eqn{\mu < 0} or \eqn{\mu > 1} for Bernoulli.}

\item{inplace}{Logical for whether to modify \code{abundDt} in-place, adding a
column \code{abund} containing the abundance values.}
}
\value{
Matrix of abundance values, where rows correspond to features and
columns correspond to samples.
}
\description{
Sample feature abundance values from the given distributions. This function
is used internally by \code{\link[=simphony]{simphony()}}, and should not usually need to be
called directly.
}
\examples{
library('data.table')
set.seed(6022)
abundDt = data.table(feature = 'feature_1', sample = c('sample_1', 'sample_2'),
                    mu = c(0, 5), sd = 1)
abundMat = getSampledAbund(abundDt)

}
\seealso{
\code{\link[=simphony]{simphony()}}, \code{\link[=getExpectedAbund]{getExpectedAbund()}}
}
