% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_palettes.R, R/shortcuts.R
\name{sc_within}
\alias{sc_within}
\alias{sc_red}
\alias{sc_orange}
\alias{sc_yellow}
\alias{sc_green}
\alias{sc_teal}
\alias{sc_blue}
\alias{sc_violet}
\alias{sc_pink}
\alias{sc_grey}
\title{Generates a palette within 1 hue}
\usage{
sc_within(hue, light = c(2:5), sat = "", return = NULL)

sc_red(light = 2:5, sat = "", return = NULL)

sc_orange(light = 2:5, sat = "", return = NULL)

sc_yellow(light = 2:5, sat = "", return = NULL)

sc_green(light = 2:5, sat = "", return = NULL)

sc_teal(light = 2:5, sat = "", return = NULL)

sc_blue(light = 2:5, sat = "", return = NULL)

sc_violet(light = 2:5, sat = "", return = NULL)

sc_pink(light = 2:5, sat = "", return = NULL)

sc_grey(light = 2:5, sat = "", return = NULL)
}
\arguments{
\item{hue}{ex: "red", "blue", "violet"}

\item{light}{the lightness of the color, ex: 1:5}

\item{sat}{the saturation of the color, ex: "bright", "muted", "dull" or "" (base)}

\item{return}{defaults to returning hex codes but can also return a table or plot of the generated palette}
}
\value{
can return a vector of hex codes, a table or a plot
}
\description{
Generates a palette within 1 hue
}
\examples{
sc_within("violet", 1:3)
sc_within("violet", 1:5, "bright" , return = "table")
sc_within("violet", 2:4, c("bright", "muted"), return = "plot")
}
\seealso{
Other palettes: 
\code{\link{sc_across}()}
}
\concept{palettes}
