% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplex_tree.R
\name{coface_roots}
\alias{coface_roots}
\title{Generates a coface roots traversal on the simplex tree.}
\usage{
coface_roots(st, sigma)
}
\arguments{
\item{st}{the simplex tree to traverse.}

\item{sigma}{simplex to start the traversal at.}
}
\description{
The coface roots of a given simplex \code{sigma} are the roots of subtrees 
in the trie whose descendents (including the roots themselves) are cofaces of \code{sigma}.
This traversal is more useful when used in conjunction with other traversals, e.g. a \emph{preorder} 
or \emph{level_order} traversal at the roots enumerates the cofaces of \code{sigma}.
}
