% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simtimer.R
\name{sim_wday}
\alias{sim_wday}
\title{Weekday part of a sim_datetime}
\usage{
sim_wday(sim_datetime, origin_date)
}
\arguments{
\item{sim_datetime}{A sim_datetime (integer representing the passed seconds since origin_date)}

\item{origin_date}{A datetime (POSIXt)}
}
\value{
A character, giving the weekday number ("1" = Monday, "2" = Tuesday, ..., "7" = Sunday)
}
\description{
sim_wday() returns the weekday of a sim_datetime. It's crucial to use the same origin_date for
sim_wday() than the origin_date that was used to generate the sim_datetime.
sim_wday() uses the base R format(x, "\%u") function.
}
\examples{
origin_date <- as.POSIXct("2016-01-01 00:00:00", tz = "UTC")
sim_wday(60, origin_date)
sim_wday(3600,origin_date)
sim_wday(36*3600,origin_date)
}
