% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plot.simule}
\alias{plot.simule}
\title{Plot simule result specified by user input}
\usage{
\method{plot}{simule}(x, graphlabel = NULL, type = "task",
  neighbouroption = "task", subID = NULL, index = NULL,
  graphlayout = NULL, ...)
}
\arguments{
\item{x}{output generated from simule/wsimule function (simule/wsimule class)}

\item{graphlabel}{vertex names for the graph, there are three options:
(1) NA (no label)
(2) NULL (default numeric label according to the feature order)
(3) a vector of labels (a vector of labels cooresponding to x)
deault value is NULL}

\item{type}{type of graph, there are four options:
(1) "task" (graph for each task (including shared part) specified further by subID (task number))
(2) "share" (shared graph for all tasks)
(3) "taskspecific" (graph for each task specific (excluding shared part)
specified further by subID (task number) )
(4) "neighbour" (zoom into nodes in the graph specified further by neighbouroptoin, subID (task number)
and index (node id))}

\item{neighbouroption}{determines what type of graph to zoom into when parameter type is "neighbour"
There are two options:
(1) "task" (zoom into graph for each task (including shared part))
(2) "taskspecific" (zoom into graph for each task specific (excluding shared part))}

\item{subID}{selects which task to display
(1) 0 (only allowed when type is task or type is neighbour and neighbouroption is task) (selecting share graph)
(2) positive task number (selects a task number)
(3) a vector of task number (selects multiple tasks)
(4) NULL (selects all tasks (all graphs))}

\item{index}{determines which node(s) to zoom into when parameter type is "neighbour"
could either be an integer or vector of integers representing node ids
(zoom into one node or multiple nodes)}

\item{graphlayout}{layout for the graph (two column matrix specifying x,y coordinates of each node in graph)
if not provided, igraph will use the default layout_nicely() function present the graph}

\item{...}{extra parameters passed to plot.igraph}
}
\value{
a plot of graph / subgraph from simule result specified by user input
}
\description{
This function can plot and return multiple sparse graphs distinguished by edge colors
from the result generated by simule
}
\details{
when only the simulresult is provided, the function will plot all graphs with default numeric labels
User can specify multiple subID and multiple index to zoom in multiple nodes on multiple graphs
Each graph will include a decriptive title and legend to indicate correspondence between edge color and task.
The function will plot graph and return an igraph object at the same time
}
\examples{
\dontrun{
data(exampleData)
result = simule(X = exampleData , lambda = 0.1, epsilon = 0.45, covType = "cov", FALSE)
plot.simule(result,  graphlabel = NULL, type="task", graphlayout = NULL)
}
}
\author{
Beilun Wang, Zhaoyang Wang (Author), Beilun Wang (maintainer)
}
