% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate_linelist.R
\name{truncate_linelist}
\alias{truncate_linelist}
\title{Adjust or subset a line list to account for right truncation}
\usage{
truncate_linelist(
  linelist,
  truncation_day = 14,
  unit = c("days", "weeks", "months", "years"),
  direction = c("backwards", "forwards")
)
}
\arguments{
\item{linelist}{Line list \verb{<data.frame>} output from \code{\link[=sim_linelist]{sim_linelist()}}.}

\item{truncation_day}{A single \code{numeric} specifying the number of
days (default), weeks, months or years before the end of the outbreak
(default) or since the start of the outbreak (see \code{direction} argument)
to truncate the line list at. By default it is 14 days before the end
of the outbreak.

Alternatively, \code{truncation_day} can accept a \verb{<Date>} and this is
used as the \code{truncation_day} and the \code{unit} and \code{direction} is ignored.}

\item{unit}{A \code{character} string, either \code{"days"} (default),
\code{"weeks"}, \code{"months"}, or \code{"years"}, specifying the units of the
\code{truncation_day} argument.

Years are assumed to be 365.25 days and months are assumed to be 365.25 / 12
days (same as \pkg{lubridate}).}

\item{direction}{A \code{character} string, either \code{"backwards"} (default) or
\code{"forwards"}. \code{direction = backwards} defines the \code{truncation_day} as
the time before the end of the outbreak. \code{direction = forwards} defines
the \code{truncation_day} as the time since the start of the outbreak.}
}
\value{
A line list \verb{<data.frame>}.

The output \verb{<data.frame>} has the same structure as the input \verb{<data.frame>}
from \code{\link[=sim_linelist]{sim_linelist()}}, but can be a subset and dates after truncation set
to \code{NA}.
}
\description{
Adjust or subset the line list \verb{<data.frame>} by removing cases that
have not been reported by the truncation time and setting hospitalisation
admission or outcome dates that are after the truncation point to \code{NA}.

This is to replicate real-time outbreak data where recent cases or outcomes
are not yet observed or reported (right truncation). It implies an assumption
that symptom onsets are reported with a delay but hospitalisations are
reported instantly.
}
\details{
The day on which the line list is truncated is the same for
all individuals in the line list, and is specified by the
\code{truncation_day} and \code{unit} arguments.
}
\examples{
set.seed(1)
linelist <- sim_linelist()
linelist_trunc <- truncate_linelist(linelist)

# set truncation point 3 weeks before the end of outbreak
linelist_trunc <- truncate_linelist(
  linelist,
  truncation_day = 3,
  unit = "weeks"
)

# set truncation point to 2 months since the start of outbreak
linelist_trunc <- truncate_linelist(
  linelist,
  truncation_day = 2,
  unit = "months",
  direction = "forwards"
)

# set truncation point to 2023-03-01
linelist_trunc <- truncate_linelist(
  linelist,
  truncation_day = as.Date("2023-03-01")
)
}
