% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTD.R
\name{MTD}
\alias{MTD}
\title{Multivariate Test of deficit}
\usage{
MTD(
  case,
  controls,
  conf_level = 0.95,
  method = c("pd", "pchi", "pf", "pmd"),
  mahalanobis_dist = NULL,
  k = NULL,
  n = NULL
)
}
\arguments{
\item{case}{Vector of case scores}

\item{controls}{Matrix or data frame with scores from the control sample, each column representing a variable}

\item{conf_level}{Level of confidence for the confidence intervals}

\item{method}{One out of "pd", "pchi", "pf" and "pmd". Use "pmd" if the Mahalanobi's distance seems suspiciously small}

\item{mahalanobis_dist}{Mahalanobi's distance of the case if summary statistics are used}

\item{k}{The number of dimensions, if summary statistics are used}

\item{n}{The size of the control sample}
}
\value{
A list with class \code{"htest"} containing the following components:
  \tabular{llll}{ \code{statistic}   \tab Hotelling's T^2 statistic for the
  case's Mahalanobi's distance \cr\cr
  \code{p.value}    \tab The p value associated with the Hotelling statistic
   \cr\cr \code{estimate} \tab Estimates of the case Mahalanobis distance
   and index as well as abnormality \cr\cr \code{interval} \tab  List
   of interval measure for the estimates \cr\cr \code{sample.size} \tab number
  of controls.\cr\cr \code{method} \tab a character
  string indicating what type of test was performed and which abnormality measure
  used}
}
\description{
Testing for abnormality in the distance between a a vector of observations
for a single case and a vector of population means. Please see vignette
for further details.
}
\examples{

caseA <- size_weight_illusion[1, "V_SWI"]
contA <- size_weight_illusion[-1, "V_SWI"]
caseB <- size_weight_illusion[1, "K_SWI"]
contB <- size_weight_illusion[-1, "K_SWI"]

MTD(case = c(caseA, caseB), controls = cbind(contA, contB),
  conf_level = 0.95, method = c("pd", "pchi", "pf", "pmd"),
  mahalanobis_dist = NULL, k = NULL, n = NULL)


}
