% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_buckets}
\alias{aws_buckets}
\title{List S3 buckets}
\usage{
aws_buckets(...)
}
\arguments{
\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/s3_list_objects/}{list_objects}}
}
\value{
if no objects found, an empty tibble. if tibble has rows each
is an S3 bucket, with 8 columns:
\itemize{
\item bucket_name (character)
\item key (character)
\item uri (character)
\item size (fs::bytes)
\item type (character)
\item owner (character)
\item etag (character)
\item last_modified (dttm)
}
}
\description{
List S3 buckets
}
\details{
internally uses \code{s3fs::s3_dir_info()}
}
\note{
we set \code{refresh=TRUE} internally to make sure we return up to date
information about your buckets rather than what's cached locally
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aws_buckets()
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_bucket_upload}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
