% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy}
\alias{aws_policy}
\title{Get a policy}
\usage{
aws_policy(name, local = FALSE, path = NULL)
}
\arguments{
\item{name}{(character) a policy name or arn}

\item{local}{(logical) if \code{TRUE} use your AWS account for your own
managed policies. If \code{FALSE}, AWS managed policies}

\item{path}{(character) if not \code{NULL}, we add the path into the ARN
before the \code{name} value}
}
\value{
a tibble with policy details
}
\description{
Get a policy
}
\details{
see docs \url{https://www.paws-r-sdk.com/docs/iam_get_policy/}
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# get an AWS managed policy (local = FALSE - the default)
aws_policy("AmazonS3FullAccess")

# get a policy by arn
aws_policy("arn:aws:iam::aws:policy/AmazonS3FullAccess")
\dontshow{\}) # examplesIf}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_entities}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
