% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policies.R
\name{aws_policy_list_entities}
\alias{aws_policy_list_entities}
\title{List policy entities}
\usage{
aws_policy_list_entities(name, ...)
}
\arguments{
\item{name}{(character) a policy name. required. within the function
we lookup the policy arn which is what's passed to the AWS API}

\item{...}{additional named arguments passed on to internal \code{paws} method
(see link below to its docs)}
}
\value{
tibble with columns:
\itemize{
\item type: one of Users, Roles, Groups
\item name: the user, role or group name
\item id: the id for the user, role or group name
}

Zero row tibble if there are no entities
}
\description{
List policy entities
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aws_policy_list_entities("AdministratorAccess")
aws_policy_list_entities("AmazonRedshiftReadOnlyAccess")
\dontshow{\}) # examplesIf}
}
\references{
\url{https://www.paws-r-sdk.com/docs/iam_list_entities_for_policy/}
}
\seealso{
Other policies: 
\code{\link{as_policy_arn}()},
\code{\link{aws_policies}()},
\code{\link{aws_policy}()},
\code{\link{aws_policy_attach}()},
\code{\link{aws_policy_create}()},
\code{\link{aws_policy_delete}()},
\code{\link{aws_policy_delete_version}()},
\code{\link{aws_policy_detach}()},
\code{\link{aws_policy_exists}()},
\code{\link{aws_policy_list_versions}()},
\code{\link{aws_policy_update}()}
}
\concept{policies}
