% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets_manager.R
\name{aws_secrets_get}
\alias{aws_secrets_get}
\title{Get a secret}
\usage{
aws_secrets_get(id, ...)
}
\arguments{
\item{id}{(character) The name or ARN of the secret. required}

\item{...}{further named parameters passed on to \code{get_secret_value}
\url{https://www.paws-r-sdk.com/docs/secretsmanager_get_secret_value/}}
}
\value{
(list) with fields:
\itemize{
\item ARN
\item Name
\item VersionId
\item SecretBinary
\item SecretString
\item VersionStages
\item CreatedDate
}
}
\description{
Get a secret
}
\examples{
\dontshow{if (aws_has_creds() && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
try({
# Create a secret
secret <- random_string("secret-", size = 16)
aws_secrets_create(
  name = secret,
  secret = '{"username":"jane","password":"cat"}',
  description = "A string"
)

aws_secrets_get(secret)

# Does exist
aws_secrets_get(id = "MyTestDatabaseSecret")

# Does not exist
try(aws_secrets_get(id = "DoesntExist"))

# Cleanup
aws_secrets_delete(secret, ForceDeleteWithoutRecovery = TRUE)
})
\dontshow{\}) # examplesIf}
}
