% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{six_bucket_add_user}
\alias{six_bucket_add_user}
\title{Add a user to a bucket}
\usage{
six_bucket_add_user(bucket, username, permissions)
}
\arguments{
\item{bucket}{(character) bucket name. required}

\item{username}{(character) A user name. required}

\item{permissions}{(character) user permissions, one of
read or write. write includes read}
}
\value{
invisibly returns nothing
}
\description{
Add a user to a bucket
}
\section{Permissions}{

\itemize{
\item read: read only; not allowed to write or do admin tasks
\item write: write (in addition to read); includes deleting files; does
not include deleting buckets
\item admin: change user permissions (in addition to read and write);
includes deleting buckets (THIS OPTION NOT ACCEPTED YET!)
}
}

\section{What is magical}{

\itemize{
\item Exits early if permissions is not length 1
\item Exits early if permissions is not in allowed set
\item Exits early if bucket does not exist
\item Creates bucket policy if not created yet
\item If user not in bucket already, attach policy to user (which adds them
to the bucket)
}
}

\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a bucket
bucket <- random_bucket()
if (!aws_bucket_exists(bucket)) {
  aws_bucket_create(bucket)
}

# create a user
user <- random_user()
if (!aws_user_exists(user)) {
  aws_user_create(user)
}

six_bucket_add_user(
  bucket = bucket,
  username = user,
  permissions = "read"
)

# cleanup
six_user_delete(user)
aws_bucket_delete(bucket, force = TRUE)

\dontrun{
# not a valid permissions string
six_bucket_add_user(
  bucket = "mybucket",
  username = "userdmgziqpt",
  permissions = "notavalidpermission"
)
}
\dontshow{\}) # examplesIf}
}
