% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skellam.reg.R
\name{skellam.reg}
\alias{skellam.reg}
\title{Skellam Regression}
\usage{
skellam.reg(y, x)
}
\arguments{
\item{y}{A vector of integers (positive or negative)}

\item{x}{A matrix, vector or data.frame of covariates}
}
\value{
A list with components:
\describe{
\item{loglik}{Maximized log-likelihood value}
\item{param1}{Matrix for \eqn{\lambda_1} parameters:
\itemize{
\item Column 1: Estimated coefficients
\item Column 2: Standard errors
\item Column 3: t-values (coef/se)
\item Column 4: p-values (Wald test)
}
}
\item{param2}{Matrix for \eqn{\lambda_2} parameters (same structure as param1)}
}
}
\description{
Fits a regression model assuming a Skellam distribution for the response variable.
}
\details{
The function uses an exponential link function to ensure positive values for both
rate parameters (\eqn{\lambda_1} and \eqn{\lambda_2}). Optimization is performed
using \code{\link[stats]{nlm}}.
}
\examples{
set.seed(0)
x <- rnorm(100)
y1 <- rpois(100, exp(1 + 1 * x))
y2 <- rpois(100, exp(-1 + 1 * x))
y <- y2 - y1
skellam.reg(y, x)

}
\references{
\itemize{
\item Skellam, J. G. (1946) The frequency distribution of the difference between
two Poisson variates belonging to different populations. \emph{Journal of the
Royal Statistical Society, Series A} \bold{109}(3), 296.

\item Strackee, J.; van der Gon, J. J. D. (1962) The frequency distribution of
the difference between two Poisson variates. \emph{Statistica Neerlandica}
\bold{16}(1), 17-23.

\item Karlis D. and Ntzoufras I. (2009) \emph{Analysis of sports data using bivariate
Poisson models}. IMA Conference Presentation.
\url{http://www2.stat-athens.aueb.gr/~jbn/papers/files/20_Karlis_Ntzoufras_2009_IMA_presentation_handouts_v01.pdf}
}
}
\author{
Michail Tsagris
}
\keyword{models}
\keyword{regression}
