% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_domain.R
\name{get_user_domain}
\alias{get_user_domain}
\title{Determine if User has joined a domain}
\usage{
get_user_domain(domain, user_ids, api_token)
}
\arguments{
\item{domain}{Skilljar domain you want to search in}

\item{user_ids}{Vector of user id's}

\item{api_token}{Your personalized token provided by 'Skilljar'}
}
\value{
A data.frame that indicates if each id is found in that domain.
}
\description{
Accepts a vector of user id's, and a domain, and returns a data.frame that
indicates if each id is found in that domain.
}
\details{
Utilizing the API requires a token. This must be obtained by logging in
at dashboard.skilljar.com and going to Organization -> API Credentials.
There are different strategies for storing api tokens securely. It is 
an unnecessary risk to store the token in the script!
}
\examples{
\dontrun{
# Retrieve user data and domain for 100 users
my_users <- get_users(users_desired = 100,
api_token = "my-token")
user_vector <- users \%>\% select(user_id) \%>\% pull()
my_users2 <- get_user_domain(user_vector, "my-domain.skilljar.com",
api_token = "my-token")
}
}
\seealso{
See \url{https://api.skilljar.com/docs/} for documentation on
the 'Skilljar' API.
}
