% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{simulate.sklarsomega}
\alias{simulate.sklarsomega}
\title{Simulate a Sklar's Omega dataset(s).}
\usage{
\method{simulate}{sklarsomega}(object, nsim = 1, seed = NULL, ...)
}
\arguments{
\item{object}{a fitted model object.}

\item{nsim}{number of datasets to simulate. Defaults to 1.}

\item{seed}{either \code{NULL} or an integer that will be used in a call to \code{\link{set.seed}} before simulating the response vector(s). If set, the value is saved as the \code{"seed"} attribute of the returned value. The default (\code{NULL}) will not change the random generator state, and \code{\link{.Random.seed}} will be returned as the \code{"seed"} attribute.}

\item{...}{additional arguments.}
}
\value{
A data frame having \code{nsim} columns, each of which contains a simulated response vector. Said data frame has a \code{"seed"} attribute, which takes the value of the \code{seed} argument or the value of \code{\link{.Random.seed}}.
}
\description{
Simulate a Sklar's Omega dataset(s).
}
\details{
This function simulates one or more responses distributed according to the fitted model.
}
\examples{
# Fit a subset of the cartilage data, assuming a Laplace marginal distribution.

data(cartilage)
data.cart = as.matrix(cartilage)[1:100, ]
colnames(data.cart) = c("c.1.1", "c.2.1")
fit.lap = sklars.omega(data.cart, level = "balance", confint = "none",
                       control = list(dist = "laplace"))
summary(fit.lap)

# Simulate three datasets from the fitted model, and then display the
# head of the first dataset in matrix form.

sim = simulate(fit.lap, nsim = 3, seed = 42)
data.sim = t(fit.lap$data)
data.sim[! is.na(data.sim)] = sim[, 1]
data.sim = t(data.sim)
head(data.sim)
}
