% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.slim}
\alias{print.slim}
\alias{print.slim_summary}
\title{Print 'slim' Objects}
\usage{
\method{print}{slim}(x, empirical = TRUE, digits = max(3,
  getOption("digits") - 3), signif.stars = getOption("show.signif.stars"),
  ...)

\method{print}{slim_summary}(x, empirical = x$empirical, ...)
}
\arguments{
\item{x}{an object of class 'slim' or 'slim_summary', as appropriate.}

\item{empirical}{logical indicating if empirical variances of y should be
used in estimating standard errors (the default). Empirical standard errors
should be used unless covariances have been well modelled.}

\item{digits}{minimal number of \emph{significant} digits, see
    \code{\link{print.default}}.}

\item{signif.stars}{logical. If \code{TRUE}, \sQuote{significance stars}
    are printed for each coefficient.}

\item{...}{arguments passed to or from other methods.}
}
\value{
x, invisibly.
}
\description{
'print' methods for class 'slim' and 'slim_summary'. 'print.slim_summary'
differs only in its default value of 'empirical'.
}
