% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alscal.R
\name{alscal}
\alias{alscal}
\title{ALSCAL - MDS via S-Stress Minimization}
\usage{
alscal(
  delta,
  type = "ratio",
  weightmat,
  init = NULL,
  ndim = 2,
  acc = 1e-06,
  itmax = 10000,
  verbose = FALSE,
  principal = FALSE
)
}
\arguments{
\item{delta}{dist object or a symmetric, numeric data.frame or matrix of distances}

\item{type}{what type of MDS to fit. Currently one of "ratio" or "interval". Default is "ratio".}

\item{weightmat}{a matrix of finite weights}

\item{init}{starting configuration}

\item{ndim}{dimension of the configuration; defaults to 2}

\item{acc}{numeric accuracy of the iteration. Default is 1e-6.}

\item{itmax}{maximum number of iterations. Default is 10000.}

\item{verbose}{should iteration information been given; if > 0 then yes}

\item{principal}{If ‘TRUE’, principal axis transformation is applied to the final configuration}
}
\value{
a 'smacofP' object (inheriting from 'smacofB', see \code{\link[smacof]{smacofSym}}). It is a list with the components
\itemize{
\item delta: Observed untransformed dissimilarities
\item tdelta: Observed explicitly transformed (squared) dissimilarities, normalized
\item dhat: Explicitly transformed dissimilarities (dhats), optimally scaled and normalized 
\item confdist: Transformed configuration distances
\item conf: Matrix of fitted configuration
\item stress: Default stress  (stress 1; sqrt of explicitly normalized stress)
\item spp: Stress per point
\item ndim: Number of dimensions
\item model: Name of smacof model
\item niter: Number of iterations
\item nobj: Number of objects
\item type: Type of MDS model
\item weightmat: weighting matrix as supplied 
\item stress.m: Default stress (stress-1^2)
\item tweightmat: transformed weighting matrix (here NULL)
}
}
\description{
An implementation to minimize s-stress by majorization with ratio and interval optimal scaling.
}
\examples{
dis<-smacof::kinshipdelta
res<-alscal(as.matrix(dis),type="interval",itmax=1000)
res
summary(res)
plot(res)

}
\seealso{
\code{\link{rStressMin}}
}
