% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.factor.gen}
\alias{smbinning.factor.gen}
\title{Utility to generate a new characteristic from a factor variable}
\usage{
smbinning.factor.gen(df, ivout, chrname = "NewChar")
}
\arguments{
\item{df}{Dataset to be updated with the new characteristic.}

\item{ivout}{An object generated after \code{smbinning.factor} or \code{smbinning.factor.custom}.}

\item{chrname}{Name of the new characteristic.}
}
\value{
A data frame with the binned version of the original characteristic.
}
\description{
It generates a data frame with a new predictive characteristic from a factor variable after applying
\code{smbinning.factor} or \code{smbinning.factor.custom}.
}
\examples{
# Load library and its dataset
library(smbinning) # Load package and its data
pop=smbsimdf1 # Set population
train=subset(pop,rnd<=0.7) # Training sample

# Binning a factor variable on training data
result=smbinning.factor(train,x="home",y="fgood")

# Example: Append new binned characteristic to population
pop=smbinning.factor.gen(pop,result,"g1home")

# Split training
train=subset(pop,rnd<=0.7) # Training sample

# Check new field counts
table(train$g1home)
table(pop$g1home)
}
