% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smle_resid.R
\name{smle_resid}
\alias{smle_resid}
\title{Extract residuals of the full likelihood proportional hazards model}
\usage{
smle_resid(y, d, x, fit, type = c("score", "deviance"))
}
\arguments{
\item{y}{survival time (> 0).}

\item{d}{right-censoring indicator, \code{1}: observed; \code{0}: right-censored.}

\item{x}{p-dimensional covariates matrix.}

\item{fit}{an object comes from the function \code{smle_ph}.}

\item{type}{type of residual, either \code{deviance} or \code{score}.}
}
\value{
\code{smle_resid} returns a numeric vector (if \code{type = "deviance"}) or a matrix (if \code{type = "score"}) of residuals extracted from the \code{object}.
}
\description{
This function extracts residuals of the full likelihood proportional hazards model estimated by the sieve estimation. Deviance-type and score-type residuals are available.
}
\details{
see Halabi et al., (2024+) for detailed method explanation.
}
\examples{
\dontshow{
library(smlePH)
set.seed(111)
n = 200
beta = c(1, -1, 0.5, -0.5, 1)
p = length(beta)
beta = matrix(beta, ncol = 1)
R = matrix(c(rep(0, p^2)), ncol = p)
diag(R) = 1
mu = rep(0, p)
SD = rep(1, p)
S = R * (SD \%*\% t(SD))
x = MASS::mvrnorm(n, mu, S)
T = (-log(runif(n)) / (2 * exp(x \%*\% beta)))^(1/2)
C = runif(n, min = 0, max = 2.9)
y = apply(cbind(T,C), 1, min)
d = (T <= C)+0
ord = order(y)
y = y[ord]; x = x[ord,]; d = d[ord]
fit = smle_ph(y = y, d = d, x = x)
}
library(smlePH)
# The 'fit' comes from an example description of smle_ph()
smle_resid(y = y, d = d, x = x, fit = fit, type = "deviance")
smle_resid(y = y, d = d, x = x, fit = fit, type = "score")
}
\references{
Halabi et al., (2024+) Sieve maximum full likelihood estimation for the proportional hazards model
}
