% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pcancer}
\alias{pcancer}
\title{Prostate Cancer Data}
\format{
A data frame with 97 rows and 9 variables:
\describe{
  \item{lcavol}{log(cancer volume (cm^3))}
  \item{lweight}{log(prostate weight (g))}
  \item{age}{age of the patient}
  \item{lbph}{log(amount of benign prostatic hyperplasia (cm^2))}
  \item{svi}{presence of seminal vesicle invasion (1=yes, 0=no)}
  \item{lcp}{log(capsular penetration (cm))}
  \item{gleason}{Gleason score}
  \item{pgg45}{percentage of Gleason scores four of five}
  \item{lpsa}{log(PSA (ng/mL))}
  }
}
\source{
\url{https://web.stanford.edu/~hastie/ElemStatLearn/datasets/prostate.data}
}
\usage{
pcancer
}
\description{
Data, which come from a study by Stamey et al. (1989), examining the
correlation between the level of prostate-specific antigen (PSA) and
various clinical measures in men who were about to receive a radical prostatectomy.
}
\references{
Stamey, T. A., Kabalin, J. N., McNeal, J. E., Johnstone, I. M., Freiha, F., Redwine,
E. A., and Yang, N. (1989). Prostate specific antigen in the diagnosis and treatment of
adenocarcinoma of the prostate. ii. radical prostatectomy treated patients. The Journal
of urology, 141(5):1076-1083.
}
\keyword{datasets}
